#include <iostream>
#include <vector>
#include <queue>

using namespace::std;

int showColored(vector<vector<int>>& tree, vector<int>& colors) {
	int p = 1;
	queue<int> q;
	q.push(0);
	while (!q.empty()) {
		int f = q.front();
		q.pop();
		for (auto i : tree[f]) {
			if (colors[i] != colors[f]) p++;
			q.push(i);
		}
	}
	return p;
}

void changeColor(int node, int c, vector<vector<int>>& tree, vector<int>& colors) {
	queue<int> q;
	q.push(node - 1);
	while (!q.empty()) {
		int f = q.front();
		q.pop();
		colors[f] = c;
		for (auto i : tree[f]) {
			q.push(i);
		}
	}
}

int main()
{
	ios_base::sync_with_stdio(false); cin.tie(NULL); cout.tie(NULL);
	int n, q;
	cin >> n >> q;
	int u, v;
	vector<vector<int>> tree(n);
	vector<int> colors(n);
	for (int i = 0; i < n - 1; i++) {
		cin >> u >> v;
		tree[u - 1].push_back(v - 1);
	}
	for (int i = 0; i < n; i++) {
		cin >> colors[i];
	}
	vector<int> rez(q);
	for (int i = 0; i < q; i++) {
		cin >> u >> v;
		changeColor(u, v, tree, colors);
		rez[i] = showColored(tree, colors);
	}
	for (auto i : rez) cout << i << endl;
	return 0;
}